% copyright 1999 by Gerrit Jahn, look at README for further details.

set terminal latex
set output "vanderwa.tex"
set size 3.0/5, 2.0/3
set title "Reales Gas nach Van-der-Waals"
set xtics ("$V_K$" 0.128,"$V$" 0.3)
set ytics ("$p_K$" 72, "$p$" 140)
set xlabel "$T_1>T_2>T_3>T_K>T_4>T_5>T_6$"
set key -0.025,75.0
plot [0.05:0.3] [0.0:140] \
 0.08205*364/(x-0.04267)-3.54/(x*x) title "$T_1$" with lines 4,\
 0.08205*344/(x-0.04267)-3.54/(x*x) title "$T_2$" with lines 1,\
 0.08205*324/(x-0.04267)-3.54/(x*x) title "$T_3$" with lines 6,\
 0.08205*304/(x-0.04267)-3.54/(x*x) title "$T_K$" with lines 3,\
 0.08205*286/(x-0.04267)-3.54/(x*x) title "$T_4$" with lines 5,\
 0.08205*268/(x-0.04267)-3.54/(x*x) title "$T_5$" with lines 1,\
 0.08205*250/(x-0.04267)-3.54/(x*x) title "$T_6$" with lines 4
