set terminal latex
set output "MaxBol3d.tex"
set size 4.0/5,2.0/3
set title "Maxwell-Boltzmann-Geschwindigkeitsverteilung"
set xtics ("$0$" 0, "$\hat u$" 1.0, "$\overline u$" 1.15,\
           "$\sqrt{\overline{u^2}}$" 1.45, "$u \to \infty$" 5)
set ytics ("" 0, "$f(u)$" 0.4)
set key 4.0,0.35
plot [0.0:5.0] [0:0.4] exp(-x*x/4)*x*x/(sqrt(4)*4) title "$T_2>T_1$" \
 with lines 1,\
 exp(-x*x)*x*x title "$T_1$" with lines 3, \
 exp(-x*x*2)*x*x/(sqrt(0.5)*0.5) title "$T_3<T_1$"with lines 4