set terminal latex
set output "lenjopot.tex"
set size 2.75/5,1.83/3
set title "Lennard-Jones-Potential"
set arrow from 0.53,5.0 to 0.3,5.0 
set arrow from 0.73,5.0 to 1.0,5.0
set label "$\delta$" at 0.58,5.0 left
set arrow from 0.75,-1 to 0.75,0
set arrow from 0.75,-2 to 0.75,-2.75
set label "$\varepsilon$" at 0.7,-1.5 left
set xtics ("$0$" 0, "" 1.0, "$\sqrt[6]{2}\delta$" 1.1225, "$r \to \infty$" 3)
set ytics ("$-\varepsilon$" -2.75, "$0$" 0, "$U \to \infty$" 6)
set nokey
plot [0.3:3.0] [-3:6] 11*((1/x)*(1/x)*(1/x)*(1/x)*(1/x)*\
           (1/x)*(1/x)*(1/x)*(1/x)*(1/x)*(1/x)*(1/x) - \
           (1/x)*(1/x)*(1/x)*(1/x)*(1/x)*(1/x))