set terminal latex
set output "Fick_ges.tex"
set size 2.0/5, 1.3/3
set title "Fick'sches Gesetz"
set xtics ("$-x$" -5.0, "$x$" 5.0 )
set ytics ("$C$" 1.0 )
set key -9.0,0.6
plot [-5.0:5.0] [0.0:1.0] exp(-x*x*0.6)*0.99 title "\tiny $t_1$" with line 2,\
 0.5*exp(-x*x*0.15) title "\tiny $t_2>t_1$" with lines 1